﻿CREATE TABLE public.depersondatasource (
  depersondatasource_id INTEGER NOT NULL,
  code VARCHAR(64) NOT NULL,
  CONSTRAINT depersondatasource_code_key UNIQUE(code),
  CONSTRAINT depersondatasource_pkey PRIMARY KEY(depersondatasource_id)
);

CREATE TABLE public.depersontable (
  depersontable_id INTEGER NOT NULL,
  originalvaluetype INTEGER NOT NULL,
  originalvalue VARCHAR(2048) NOT NULL,
  depersonvalue VARCHAR(256) NOT NULL,
  depersondatasource_id INTEGER NOT NULL,
  CONSTRAINT depersontable_pkey PRIMARY KEY(depersontable_id),
  CONSTRAINT fk_depersontable_datasource FOREIGN KEY (depersondatasource_id) REFERENCES public.depersondatasource(depersondatasource_id)
);

CREATE SEQUENCE public.depersondatasource_seq
    START WITH 1
    INCREMENT BY 1;
	
CREATE SEQUENCE public.depersontable_seq
    START WITH 1
    INCREMENT BY 1;